% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.dbscan_fast}
\alias{predict.optics}
\alias{predict.hdbscan}
\title{Assigning New Points to a Clustering}
\usage{
\method{predict}{dbscan_fast}(object, newdata, data, ...)

\method{predict}{optics}(object, newdata, data, ...)

\method{predict}{hdbscan}(object, newdata, data, ...)
}
\arguments{
\item{object}{clustering object.}

\item{newdata}{new data points for which the cluster membership should be
predicted.}

\item{data}{the data set used to create the clustering object.}

\item{...}{further arguments.}
}
\description{
Predict the membership of a new point given a clustering.
}
\details{
\strong{For DBSCAN:} If a new point is in the eps neighborhood of a point in the clustering, the
the label of that point is predicted, otherwise the prediction is \code{0} (noise).

\strong{For OPTICS:} Extracts a DBSCAN clustering and use predict for DBSCAN.

\strong{For HDBSCAN:} Find the k-nearest neighbors with the smallest mutual
reachability distance to predict the label
}
\seealso{
Other clustering functions: 
\code{\link{dbscan}()},
\code{\link{extractFOSC}()},
\code{\link{hdbscan}()},
\code{\link{jpclust}()},
\code{\link{optics}()},
\code{\link{sNNclust}()}
}
\concept{clustering functions}
