% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NN.R
\name{NN}
\alias{NN}
\alias{adjacencylist}
\alias{adjacencylist.NN}
\alias{sort.NN}
\alias{plot.NN}
\title{NN --- Nearest Neighbors Superclass}
\usage{
adjacencylist(x, ...)

\method{adjacencylist}{NN}(x, ...)

\method{sort}{NN}(x, decreasing = FALSE, ...)

\method{plot}{NN}(x, data, main = NULL, ...)
}
\arguments{
\item{x}{a \code{NN} object}

\item{...}{further parameters}

\item{decreasing}{sort in decreasing order?}

\item{data}{that was used to create \code{x}}

\item{main}{title}
}
\description{
NN is an abstract S3 superclass for the classes of the objects returned
by \code{\link[=kNN]{kNN()}}, \code{\link[=frNN]{frNN()}} and \code{\link[=sNN]{sNN()}}. Methods for sorting, plotting and getting an
adjacency list are defined.
}
\section{Subclasses}{

\link{kNN}, \link{frNN} and \link{sNN}
}

\examples{
data(iris)
x <- iris[, -5]

# finding kNN directly in data (using a kd-tree)
nn <- kNN(x, k=5)
nn

# plot the kNN where NN are shown as line conecting points.
plot(nn, x)

# show the first few elements of the adjacency list
head(adjacencylist(nn))

\dontrun{
# create a graph and find connected components (if igraph is installed)
library("igraph")
g <- graph_from_adj_list(adjacencylist(nn))
comp <- components(g)
plot(x, col = comp$membership)

# detect clusters (communities) with the label propagation algorithm
cl <- membership(cluster_label_prop(g))
plot(x, col = cl)
}
}
\seealso{
Other NN functions: 
\code{\link{frNN}()},
\code{\link{kNNdist}()},
\code{\link{kNN}()},
\code{\link{sNN}()}
}
\author{
Michael Hahsler
}
\concept{NN functions}
\keyword{model}
