% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate-sql.R
\name{translate_sql}
\alias{translate_sql}
\alias{translate_sql_}
\title{Translate an expression to sql.}
\usage{
translate_sql(
  ...,
  con = simulate_dbi(),
  vars = character(),
  vars_group = NULL,
  vars_order = NULL,
  vars_frame = NULL,
  window = TRUE
)

translate_sql_(
  dots,
  con = NULL,
  vars_group = NULL,
  vars_order = NULL,
  vars_frame = NULL,
  window = TRUE,
  context = list()
)
}
\arguments{
\item{..., dots}{Expressions to translate. \code{translate_sql()}
automatically quotes them for you.  \code{translate_sql_()} expects
a list of already quoted objects.}

\item{con}{An optional database connection to control the details of
the translation. The default, \code{NULL}, generates ANSI SQL.}

\item{vars}{Deprecated. Now call \code{\link[=partial_eval]{partial_eval()}} directly.}

\item{vars_group, vars_order, vars_frame}{Parameters used in the \code{OVER}
expression of windowed functions.}

\item{window}{Use \code{FALSE} to suppress generation of the \code{OVER}
statement used for window functions. This is necessary when generating
SQL for a grouped summary.}

\item{context}{Use to carry information for special translation cases. For example, MS SQL needs a different conversion for is.na() in WHERE vs. SELECT clauses.  Expects a list.}
}
\description{
Translate an expression to sql.
}
\section{Base translation}{

The base translator, \code{base_sql},
provides custom mappings for \code{!} (to NOT), \code{&&} and \code{&} to
\code{AND}, \code{||} and \code{|} to \code{OR}, \code{^} to \code{POWER},
\verb{\%>\%} to \verb{\%}, \code{ceiling} to \code{CEIL}, \code{mean} to
\code{AVG}, \code{var} to \code{VARIANCE}, \code{tolower} to \code{LOWER},
\code{toupper} to \code{UPPER} and \code{nchar} to \code{LENGTH}.

\code{c()} and \code{:} keep their usual R behaviour so you can easily create
vectors that are passed to sql.

All other functions will be preserved as is. R's infix functions
(e.g. \verb{\%like\%}) will be converted to their SQL equivalents
(e.g. \code{LIKE}). You can use this to access SQL string concatenation:
\code{||} is mapped to \code{OR}, but \verb{\%||\%} is mapped to \code{||}.
To suppress this behaviour, and force errors immediately when dplyr doesn't
know how to translate a function it encounters, using set the
\code{dplyr.strict_sql} option to \code{TRUE}.

You can also use \code{\link[=sql]{sql()}} to insert a raw sql string.
}

\section{SQLite translation}{

The SQLite variant currently only adds one additional function: a mapping
from \code{sd()} to the SQL aggregation function \code{STDEV}.
}

\examples{
# Regular maths is translated in a very straightforward way
translate_sql(x + 1)
translate_sql(sin(x) + tan(y))

# Note that all variable names are escaped
translate_sql(like == "x")
# In ANSI SQL: "" quotes variable _names_, '' quotes strings

# Logical operators are converted to their sql equivalents
translate_sql(x < 5 & !(y >= 5))
# xor() doesn't have a direct SQL equivalent
translate_sql(xor(x, y))

# If is translated into case when
translate_sql(if (x > 5) "big" else "small")

# Infix functions are passed onto SQL with \% removed
translate_sql(first \%like\% "Had\%")
translate_sql(first \%is\% NA)
translate_sql(first \%in\% c("John", "Roger", "Robert"))

# And be careful if you really want integers
translate_sql(x == 1)
translate_sql(x == 1L)

# If you have an already quoted object, use translate_sql_:
x <- quote(y + 1 / sin(t))
translate_sql_(list(x), con = simulate_dbi())

# Windowed translation --------------------------------------------
# Known window functions automatically get OVER()
translate_sql(mpg > mean(mpg))

# Suppress this with window = FALSE
translate_sql(mpg > mean(mpg), window = FALSE)

# vars_group controls partition:
translate_sql(mpg > mean(mpg), vars_group = "cyl")

# and vars_order controls ordering for those functions that need it
translate_sql(cumsum(mpg))
translate_sql(cumsum(mpg), vars_order = "mpg")
}
