% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{parse_drug_affected_organisms}
\alias{parse_drug_affected_organisms}
\title{Extracts the drug affected organisms element and return data as tibble.}
\usage{
parse_drug_affected_organisms(save_table = FALSE, save_csv = FALSE,
  csv_path = ".", override_csv = FALSE)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed dataframe if true}

\item{csv_path}{location to save csv files into it, default is current location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the new parse operation}
}
\value{
drug affected organisms node attributes tibble
}
\description{
\code{parse_drug_affected_organisms} returns tibble of drug affected organisms elements.
}
\details{
This functions extracts the affected organisms element of drug node in drugbank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned tibble in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\donttest{
# return only the parsed dataframe
parse_drug_affected_organisms()

# save in database and return parsed dataframe
parse_drug_affected_organisms(save_table = TRUE)

# save parsed dataframe as csv if it does not exist in current
# location and return parsed dataframe.
# If the csv exist before read it and return its data.
parse_drug_affected_organisms(save_csv = TRUE)

# save in database, save parsed dataframe as csv if it does not exist
# in current location and return parsed dataframe.
# If the csv exist before read it and return its data.
parse_drug_affected_organisms(ssave_table = TRUE, save_csv = TRUE)

# save parsed dataframe as csv if it does not exist in given location
# and return parsed dataframe.
# If the csv exist before read it and return its data.
parse_drug_affected_organisms(save_csv = TRUE, csv_path = TRUE)

# save parsed dataframe as csv if it does not exist in current
# location and return parsed dataframe.
# If the csv exist override it and return it.
parse_drug_affected_organisms(save_csv = TRUE, csv_path = TRUE, override = TRUE)
}
}
