% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingness_summary.R
\name{missingness_summary}
\alias{missingness_summary}
\title{Missingness Summary}
\usage{
missingness_summary(DS.data, non.NA.missing.codes = NA, threshold = 95)
}
\arguments{
\item{DS.data}{Data set.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}

\item{threshold}{Threshold for missingness of concern (as a percent).}
}
\value{
Tibble containing: (1) Message containing information on the number of variables with a \% missingness greater than the threshold; (2) Missingness by variable summary; and (3) Summary of missingness for variables with a missingness level greater than the threshold.
}
\description{
This awareness function summarizes the amount of missingness in the data set.
}
\examples{
# Correct useage
data(ExampleA)
missingness_summary(DS.data.A, non.NA.missing.codes=c(-4444, -9999))
}
\seealso{
\code{\link{create_awareness_report}}
}
