% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_phylo.R
\name{summary_matrix_to_phylo}
\alias{summary_matrix_to_phylo}
\title{Go from a summary matrix to an ultrametric \code{phylo} object.}
\usage{
summary_matrix_to_phylo(
  summ_matrix,
  datelife_query = NULL,
  target_tree = NULL,
  total_distance = TRUE,
  use = "mean",
  ...
)
}
\arguments{
\item{summ_matrix}{Any summary patristic distance matrix, such as the ones obtained with \code{\link[=datelife_result_sdm_matrix]{datelife_result_sdm_matrix()}} or \code{\link[=datelife_result_median_matrix]{datelife_result_median_matrix()}}.}

\item{datelife_query}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}

\item{target_tree}{A \code{phylo} object. Use this in case you want a specific
backbone for the output tree.}

\item{total_distance}{Whether the input \code{summ_matrix} stores total age distance
(from tip to tip) or distance from node to tip. Default to \code{TRUE},
divides the matrix in half, if \code{FALSE} it will take it as is.}

\item{use}{A character vector indicating what type of age to use for summary tree.
One of the following:
\describe{
\item{"mean"}{It will use the \code{\link[=mean]{mean()}} of the node ages in \code{summ_matrix}.}
\item{"median"}{It uses the \code{\link[stats:median]{stats::median()}} age of node ages in \code{summ_matrix}.}
\item{"min"}{It will use the \code{\link[=min]{min()}} age from node ages in \code{summ_matrix}.}
\item{"max"}{Choose this if you wanna be conservative; it will use the \code{\link[=max]{max()}}
age from node ages in \code{summ_matrix}.}
\item{"midpoint"}{It will use the mean of minimum age and maximum age.}
}}

\item{...}{
  Arguments passed on to \code{\link[=summary_matrix_to_phylo_all]{summary_matrix_to_phylo_all}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
An ultrametric phylo object.
}
\description{
Go from a summary matrix to an ultrametric \code{phylo} object.
}
\details{
It can take a regular patristic distance matrix, but there are simpler
methods for that implemented in \code{\link[=patristic_matrix_to_phylo]{patristic_matrix_to_phylo()}}.
}
