% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_data.R
\name{get_bold_data}
\alias{get_bold_data}
\title{Get genetic data from the Barcode of Life Database (BOLD) for a set of taxon names.}
\usage{
get_bold_data(
  input = c("Rhea americana", "Struthio camelus", "Gallus gallus"),
  marker = "COI",
  ...
)
}
\arguments{
\item{input}{One of the following:
\describe{
\item{A character vector}{With taxon names as a single comma separated
starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or
\code{multiPhylo} object, OR as a newick character string.}
\item{A \code{datelifeQuery} object}{An output from \code{\link[=make_datelife_query]{make_datelife_query()}}.}
}}

\item{marker}{A character vector indicating the gene from BOLD system to be
used for branch length estimation. It searches "COI" marker by default.}

\item{...}{
  Arguments passed on to \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree}}
  \describe{
    \item{\code{otol_version}}{Version of Open Tree of Life to use}
    \item{\code{resolve}}{Defaults to \code{TRUE}. Whether to resolve the tree at random or not.}
    \item{\code{ott_ids}}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}.}
  }}
}
\value{
A \code{phylo} object. If there are enough BOLD sequences available for the
\code{input} taxon names, the function returns a tree with branch lengths proportional
to relative substitution rate. If not enough BOLD sequences are available
for the \code{input} taxon names, the function returns the topology given as
\code{input}, or a synthetic Open Tree of Life for the taxon names given in
\code{input}, obtained with \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree()}}.
}
\description{
\code{get_bold_data} uses taxon names from a tree topology, a character
vector of names or a \code{datelifeQuery} object, to search for genetic markers
in the Barcode of Life Database (BOLD).
}
\details{
If \code{input} is a \code{phylo} object or a newick string, it is used as backbone topology.
If \code{input} is a character vector of taxon names, an induced synthetic OpenTree
subtree is used as backbone.
}
