% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_ci.R
\name{reshape_ci}
\alias{reshape_ci}
\title{Reshape CI between wide/long formats}
\usage{
reshape_ci(x, ci_type = "CI")
}
\arguments{
\item{x}{A data frame containing columns named \code{CI_low} and \code{CI_high} (or
similar, see \code{ci_type}).}

\item{ci_type}{String indicating the "type" (i.e. prefix) of the interval
columns. Per \emph{easystats} convention, confidence or credible intervals are
named \code{CI_low} and \code{CI_high}, and the related \code{ci_type} would be \code{"CI"}.
If column names for other intervals differ, \code{ci_type} can be used to
indicate the name, e.g. \code{ci_type = "SI"} can be used for support intervals,
where the column names in the data frame would be \code{SI_low} and \code{SI_high}.}
}
\value{
A data frame with columns corresponding to confidence intervals reshaped
either to wide or long format.
}
\description{
Reshape CI between wide/long formats.
}
\examples{
x <- data.frame(
  Parameter = c("Term 1", "Term 2", "Term 1", "Term 2"),
  CI = c(.8, .8, .9, .9),
  CI_low = c(.2, .3, .1, .15),
  CI_high = c(.5, .6, .8, .85),
  stringsAsFactors = FALSE
)

reshape_ci(x)
reshape_ci(reshape_ci(x))
}
