% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{dimensions}
\alias{dimensions}
\alias{dimensions<-}
\title{Dimensions of a dataset}
\usage{
dimensions(x)

dimensions(x, sdmx_attributes = NULL) <- value
}
\arguments{
\item{x}{A data.frame or inherited tibble, data.frame, or a structured list.}

\item{sdmx_attributes}{The optional dimensions and attributes that conform with
SDMX. \code{c("time", "geo")} will mark the "time" and "geo" attributes as conforming to
sdmx. See \href{https://raw.githubusercontent.com/UKGovLD/publishing-statistical-data/master/specs/src/main/vocab/sdmx-attribute.ttl}{sdmx-attribute}.}

\item{value}{The name or column number of the within the dataset.}
}
\value{
A data frame of the names, class, isDefinedBy, and codeList properties of the
dimensions columns of the dataset following the datacube model.
}
\description{
Dimensions of a dataset
}
\details{
Do not confuse with \code{base::dim}. The \href{https://www.w3.org/TR/vocab-data-cube/#dsd-dimensions}{dimension} in the definition
of the DataSet is different from the 'dimension' definition of the R language.
}
\examples{
df <- data.frame ( sex = c("M", "F"), value = c(1,2), unit = c("NR", "NR"))
dimensions(df, sdmx_attributes = "sex") <- "sex"
measures(df) <- "value"
attributes_measures(df) <- "unit"
dimensions(df)
}
