% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{CreateRatingTable}
\alias{CreateRatingTable}
\title{Creates and validates a new rating table from an uploaded CSV.}
\usage{
CreateRatingTable(
  project,
  parentModelId,
  dataSource,
  ratingTableName = "Uploaded Rating Table"
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{parentModelId}{integer. The id of the model to validate the rating table against.}

\item{dataSource}{object. Either (a) the name of a CSV file, or (b) a
dataframe. This parameter identifies the source of the rating table.}

\item{ratingTableName}{character. Optional. The name of the rating table.}
}
\value{
An integer value that can be used as the JobId parameter
  in subsequent calls representing this job.
}
\description{
Creates and validates a new rating table from an uploaded CSV.
}
\examples{
\dontrun{
   projectId <- "5984b4d7100d2b31c1166529"
   modelId <- "5984b4d7100d2b31c1166529"
   CreateRatingTable(projectId, modelId, dataSource = "myRatingTable.csv")
}
}
