% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{ConstructDurationString}
\alias{ConstructDurationString}
\title{Construct a valid string representing a duration in accordance with ISO8601}
\usage{
ConstructDurationString(years = 0, months = 0, days = 0, hours = 0,
  minutes = 0, seconds = 0)
}
\arguments{
\item{years}{integer. The number of years in the duration.}

\item{months}{integer. The number of months in the duration.}

\item{days}{integer. The number of days in the duration.}

\item{hours}{integer. The number of hours in the duration.}

\item{minutes}{integer. The number of minutes in the duration.}

\item{seconds}{integer. The number of seconds in the duration.}
}
\value{
The duration string, specified compatibly with ISO8601.
}
\description{
A duration of six months, 3 days, and 12 hours could be represented as P6M3DT12H.
}
\examples{
ConstructDurationString()
ConstructDurationString(days = 100)
ConstructDurationString(years = 10, months = 2, days = 5, seconds = 12)
}
