% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{daily_repetition}
\alias{daily_repetition}
\title{Daily repetition test}
\usage{
daily_repetition(dailydata, meta = NULL, outpath, n = 4)
}
\arguments{
\item{dailydata}{A character string giving the path of the input file,
or a 5-column matrix with following columns: variable code, year, month,
day, and the daily value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{dailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{n}{Number of minimum equal consecutive values required for a flag. The
default is 4.}
}
\description{
Report occurrences of equal consecutive values in daily data.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).

Zeroes are automatically excluded in bounded variables such as precipitation.
}
\examples{
daily_repetition(Rosario$Tx, Meta$Tx, outpath = tempdir(), n = 3)

}
\author{
Alba Gilabert, Yuri Brugnara
}
