% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsef.R
\name{bsef}
\alias{bsef}
\title{Get Bloomberg SEF data}
\usage{
bsef(date, asset_class)
}
\arguments{
\item{date}{the date for which data is required as Date or DateTime object.
Only the year, month and day elements of the object are used. Must be of
length one.}

\item{asset_class}{the asset class for which you would like to download
trade data. Valid inputs are \code{"CR"} (credit), \code{"IR"} (rates),
\code{"EQ"} (equities), \code{"FX"} (foreign exchange), \code{"CO"}
(commodities) and must be a string.}
}
\value{
a tibble containing the requested data, or an empty tibble
if data is unavailable
}
\description{
The Bloomberg Swap Execution Facility (SEF) offers customers the ability to
execute derivative instruments across a number of different asset classes.
It is required to make publicly available price, trading volume and other
trading data. It publishes this data on its website. I have reverse
engineered the JavaScript libraries used by its website to call the
Bloomberg Application Service using \code{POST} requests to a target URL.
}
\examples{
\dontrun{
library (lubridate)
# All asset classes
bsef(ymd(20140528), "IR")
}
}
\references{
\href{http://data.bloombergsef.com}{Bloomberg SEF data}
}
