% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{crown}
\alias{crown}
\title{Tree crown radii}
\format{
Contains of variables, as follows:
\describe{
\item{spp}{Species code. 'Ro' is Nothofagus obliqua (roble), 'Co' is Nothofagus dombeyi (Coigue) and 'Ol' is Olivillo.}
\item{dbh}{Diameter at breast height, in cm.}
\item{htot}{Total height, in m.}
\item{crad.n}{Crown radii towards the north, in m.}
\item{crad.e}{Crown radii towards the east, in m.}
 \item{crad.s}{Crown radii towards the south, in m.}
\item{crad.w}{Crown radii towards the west, in m.}
\item{x.coord}{Cardinal position at the X-axis, in m.}
\item{y.coord}{Cardinal position at the Y-axis, in m.}
\item{cr.diam}{Crown diameter, in m.}
 }
}
\source{
Data were provided by Dr Christian Salas-Eljatib, Universidad de Chile (Santiago, Chile).
}
\usage{
data(crown)
}
\description{
Crown radii measurements in cardinal directions for sample trees at the Rucamanque experimental forest, near Temuco, Chile.
 Data were collected within a sample plot of 250 m\eqn{^{2}}{^2}, located in a secondary forest stand
 dominated by Nothofagus obliqua.
}
\examples{
data(crown)    
table(crown$spp) 
descstat(crown[,c("dbh","cr.diam")])
}
\references{
- Salas C. 2001. Caracterización básica del relicto de Biodiversidad 
Rucamanque [Basic characterization of the biodiversity remnant Rucamanque]. Bosque Nativo, 29:3-9. \url{https://eljatib.com/publication/2001-06-01_caracterizacion_basi/}

- Salas C, and Garcia O. 2006. Modelling height development of mature Nothofagus obliqua. 
Forest Ecology and Management 229 (1-3): 1–6. \doi{10.1016/j.foreco.2006.04.015}
}
\keyword{datasets}
