% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{search_by_title}
\alias{search_by_title}
\title{Creates a data.frame containing datasets from datos.gob.es}
\usage{
search_by_title(title, numentry = 50, page = 0)
}
\arguments{
\item{title}{Title to search}

\item{numentry}{Number of results for page}

\item{page}{The number of page to see, the first page is 0}
}
\value{
A data.frame containing information about datasets that match with
the title param
}
\description{
Send a request to datos.gob.es using the title param
to search datasets that match with the title, then the results are returned
as data.frame
}
\examples{
library(dataesgobr)
\donttest{
# Return first 50 matches that contain puente in their title
mydataesgobr <- search_by_title('puente')

# Return the first 78 matches that contain gasto in their title
mydataesgobr <- search_by_title('gasto', 78)

# Return the first 78 matches that contain gasto in their title found in the
# second page (number 1)
mydataesgobr <- search_by_title('gasto', 78, page = 1)
}
}
