% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dictionary.R
\name{create_dictionary}
\alias{create_dictionary}
\title{Create a data dictionary from any dataset}
\usage{
create_dictionary(dataset, id_var = NULL, file = NULL, var_labels = NULL)
}
\arguments{
\item{dataset}{The dataset you wish to summarise}

\item{id_var}{A variable/vector of variables that are identifiers (optional)}

\item{file}{The file path to write an Excel spreadsheet (optional)}

\item{var_labels}{A named vector of variable labels (optional)}
}
\value{
Either an Excel spreadsheet or a dataframe
}
\description{
Create a data dictionary from any dataset
}
\examples{

 # A simple dictionary printed to console
 create_dictionary(esoph)

 # You can specify id variable/s
 mtcars$id <- 1:nrow(mtcars)
 create_dictionary(mtcars, id_var = "id")

 # You can also specify labels with a named vector
 iris.labels <- c(Sepal.Length = "Sepal length in mm",
     Sepal.Width = "Sepal width in mm")
 create_dictionary(iris, var_labels = iris.labels)

}
