% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_login_client.R
\name{make_login_client}
\alias{make_login_client}
\title{Log In To Databrary.org.}
\usage{
make_login_client(
  email = NULL,
  password = NULL,
  store = FALSE,
  overwrite = FALSE,
  vb = options::opt("vb"),
  SERVICE = KEYRING_SERVICE,
  rq = NULL
)
}
\arguments{
\item{email}{Databrary account email address.}

\item{password}{Databrary password (not recommended as it will displayed as you type)}

\item{store}{A boolean value. If TRUE store/retrieve credentials from the system keyring/keychain.}

\item{overwrite}{A boolean value. If TRUE and store is TRUE, overwrite/ update stored credentials in keyring/keychain.}

\item{vb}{Show verbose messages. (Defaults to \code{FALSE}, overwritable using option 'databraryr.vb' or environment variable 'R_DATABRARYR_VB')}

\item{SERVICE}{A character label for stored credentials in the keyring. Default is "databrary"}

\item{rq}{An \code{httr2} request object. Defaults to NULL.}
}
\value{
Logical value indicating whether log in is successful or not.
}
\description{
Log In To Databrary.org.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
make_login_client() # Queries user for email and password interactively.
\dontshow{\}) # examplesIf}
\donttest{
\dontrun{
# The following shows how to use credentials that have been stored previously.

make_login_client(email = "you@provider.com", store = TRUE)
}
}

}
