% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_session_asset.R
\name{download_session_asset}
\alias{download_session_asset}
\title{Download Asset From Databrary.}
\usage{
download_session_asset(
  asset_id = 1,
  session_id = 9807,
  file_name = NULL,
  target_dir = tempdir(),
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{asset_id}{Asset id for target file.}

\item{session_id}{Slot/session number where target file is stored.}

\item{file_name}{Name for downloaded file. Default is NULL.}

\item{target_dir}{Directory to save the downloaded file.
Default is a temporary directory given by a call to \code{tempdir()}.}

\item{vb}{A Boolean value. If TRUE provides verbose output.}

\item{rq}{An \code{httr2} request object.}
}
\value{
Full file name to the asset.
}
\description{
Download Asset From Databrary.
}
\examples{
\donttest{
download_session_asset() # Download's 'numbers' file from volume 1.
download_session_asset(asset_id = 11643, session_id = 9825, file_name = "rdk.mp4")
#' # Downloads a display with a random dot kinematogram (RDK).
}
}
