% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_csv_table.R
\name{write_csv_table}
\alias{write_csv_table}
\title{Write Symbolic Data Table}
\usage{
write_csv_table(data, file, output)
}
\arguments{
\item{data}{The conventional data.}

\item{file}{The name of the CSV file.}

\item{output}{This is an experimental argument, with default TRUE, and can be ignored by most users.}
}
\value{
Write in CSV file the symbolic data table.
}
\description{
This function write (save) a symbolic data table from a CSV data file.
}
\examples{
data(mushroom)
mushroom.set <- set_variable_format(data = mushroom, location = 8, var = "Species")
mushroom.tmp <- RSDA_format(data = mushroom.set, sym_type1 = c("I", "S"),
                            location = c(25, 31), sym_type2 = c("S", "I", "I"),
                            var = c("Species", "Stipe.Length_min", "Stipe.Thickness_min"))
mushroom.clean <- clean_colnames(data = mushroom.tmp)
# We can save the file in CSV to RSDA format as follows:
write_csv_table(data = mushroom.clean, file = "mushroom_interval.csv", output = FALSE)
}
