% Generated by roxygen2 (4.0.2): do not edit by hand
\name{importWaterML1}
\alias{importWaterML1}
\title{Function to return data from the NWISWeb WaterML1.1 service}
\usage{
importWaterML1(obs_url, asDateTime = FALSE, tz = "")
}
\arguments{
\item{obs_url}{character containing the url for the retrieval}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, Date}

\item{tz}{character to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
datetime \tab POSIXct \tab The date and time of the value converted to UTC (if asDateTime = TRUE), \cr
\tab character \tab or raw character string (if asDateTime = FALSE) \cr
tz_cd \tab character \tab The time zone code for datetime \cr
code \tab character \tab Any codes that qualify the corresponding value\cr
value \tab numeric \tab The numeric value for the parameter \cr
}
Note that code and value are repeated for the parameters requested. The names are of the form
X_D_P_S, where X is literal,
D is an option description of the parameter,
P is the parameter code,
and S is the statistic code (if applicable).

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
variableInfo \tab data.frame \tab A data frame containing information on the requested parameters \cr
statisticInfo \tab data.frame \tab A data frame containing information on the requested statistics on the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
}
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate.
}
\examples{
siteNumber <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- '00003'
property <- '00060'
obs_url <- constructNWISURL(siteNumber,property,startDate,endDate,'dv')

data <- importWaterML1(obs_url,TRUE)

groundWaterSite <- "431049071324301"
startGW <- "2013-10-01"
endGW <- "2014-06-30"
groundwaterExampleURL <- constructNWISURL(groundWaterSite, NA,
          startGW,endGW, service="gwlevels")
groundWater <- importWaterML1(groundwaterExampleURL)

unitDataURL <- constructNWISURL(siteNumber,property,
         "2013-11-03","2013-11-03",'uv')
unitData <- importWaterML1(unitDataURL,TRUE)

filePath <- system.file("extdata", package="dataRetrieval")
fileName <- "WaterML1Example.xml"
fullPath <- file.path(filePath, fileName)
importUserWM1 <- importWaterML1(fullPath,TRUE)

# Two sites, two pcodes, one site has two data descriptors:
siteNumber <- c('01480015',"04085427")
obs_url <- constructNWISURL(siteNumber,c("00060","00010"),startDate,endDate,'dv')
data <- importWaterML1(obs_url)
data$dateTime <- as.Date(data$dateTime)
data <- renameNWISColumns(data)
names(attributes(data))
attr(data, "url")
attr(data, "disclaimer")

inactiveSite <- "05212700"
inactiveSite <- constructNWISURL(inactiveSite, "00060", "2014-01-01", "2014-01-10",'dv')
inactiveSite <- importWaterML1(inactiveSite)

inactiveAndAcitive <- c("07334200","05212700")
inactiveAndAcitive <- constructNWISURL(inactiveAndAcitive, "00060", "2014-01-01", "2014-01-10",'dv')
inactiveAndAcitive <- importWaterML1(inactiveAndAcitive)
}
\seealso{
\code{\link{renameNWISColumns}}
}

