% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setColAs.R
\name{setColAsCharacter}
\alias{setColAsCharacter}
\title{Set columns as character}
\usage{
setColAsCharacter(dataSet, cols, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{list of column(s) name(s) of dataSet to transform into characters}

\item{verbose}{should the function log (logical, default to TRUE)}
}
\value{
dataSet (as a \code{\link{data.table}}), with specified columns set as character.
}
\description{
Set as character a column (or a list of columns) from a data.table
}
\examples{
# Build a fake data.frame
dataSet <- data.frame(numCol = c(1, 2, 3), factorCol = as.factor(c("a", "b", "c")))

# Set numCol and factorCol as character
dataSet <- setColAsCharacter(dataSet, cols = c("numCol", "factorCol"))
}
