% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.callrate.r
\name{gl.report.callrate}
\alias{gl.report.callrate}
\title{Reports summary of Call Rate for loci or individuals}
\usage{
gl.report.callrate(
  x,
  method = "loc",
  by_pop = FALSE,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  bins = 50,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{method}{Specify the type of report by locus (method='loc') or
individual (method='ind') [default 'loc'].}

\item{by_pop}{Whether report by population [default FALSE].}

\item{plot.out}{Specify if plot is to be produced [default TRUE].}

\item{plot_theme}{User specified theme [default theme_dartR()].}

\item{plot_colors}{Vector with two color names for the borders and fill
[default two_colors].}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns unaltered genlight object
}
\description{
SNP datasets generated by DArT have missing values primarily arising from
failure to call a SNP because of a mutation at one or both of the restriction
enzyme recognition sites. P/A datasets (SilicoDArT) have missing values
because it was not possible to call whether a sequence tag was amplified or
not. This function tabulates the number of missing values as quantiles.
}
\details{
This function expects a genlight object, containing either SNP data or
SilicoDArT (=presence/absence data).

Callrate is summarized by locus or by individual to allow sensible decisions
on thresholds for filtering taking into consideration consequential loss of
data. The summary is in the form of a tabulation and plots.

Plot themes can be obtained from:
 \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }

Resultant ggplots and the tabulation are saved to the session's temporary
directory.
}
\examples{
 \donttest{
# SNP data
  test.gl <- testset.gl[1:20,]
  gl.report.callrate(test.gl)
  gl.report.callrate(test.gl,method='ind')
# Tag P/A data
  test.gs <- testset.gs[1:20,]
  gl.report.callrate(test.gs)
  gl.report.callrate(test.gs,method='ind')
  }
  test.gl <- testset.gl[1:20,]
  gl.report.callrate(test.gl)
  
}
\seealso{
\code{\link{gl.filter.callrate}}

Other report functions: 
\code{\link{gl.report.bases}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.heterozygosity}()},
\code{\link{gl.report.hwe}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.parent.offspring}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.sexlinked}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{report functions}
