% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.fst.pop.r
\name{gl.fst.pop}
\alias{gl.fst.pop}
\title{Calculate a pairwise fst values for populations in a genlight object}
\usage{
gl.fst.pop(x, nboots = 100, percent = 95, nclusters = 1)
}
\arguments{
\item{x}{-- name of the genlight containing the SNP genotypes [required]}

\item{nboots}{-- number of bootstraps to perform across loci to generate confidence intervals and p-values}

\item{percent}{-- the percentile to calculate the confidence interval around [defalut = 95]}

\item{nclusters}{-- the number of proccesor threads or cores to use during calculations.}
}
\value{
A matrix of distances between populations (class dist), if nboots =1, otherwise a list with Fsts (in a matrix), Pvalues (a matrix of pvalues), Bootstraps results (data frame of all runs). Hint: Use \code{as.matrix(as.dist(fsts))} if you want to have a squared matrix with symmetric entries returned, instead of a dist object.
}
\description{
This script calculates pairwise fst values based on the implementation in the StAMPP package (?stamppFst). It allows to run bootstrap to estimate probability of fst values to be different from zero. For detailed information please check the help pages (?stamppFst).
}
\examples{
gl.fst.pop(possums.gl, nboots=1)
}
\author{
Bernd Gruber (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
