% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.secondaries.r
\name{gl.filter.secondaries}
\alias{gl.filter.secondaries}
\title{Filter loci that represent secondary SNPs in a genlight \{adegenet\} object}
\usage{
gl.filter.secondaries(x, method = "random", verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{method}{-- method of selecting SNP locus to retain, best or random [random]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2, unless specified using gl.set.verbosity]}
}
\value{
The reduced genlight, plus a summary
}
\description{
SNP datasets generated by DArT include fragments with more than one SNP and record them 
separately with the same CloneID (=AlleleID).
These multiple SNP loci within a fragment (secondaries) are likely to be linked, 
and so you may wish to remove secondaries.
}
\details{
This script filters out all but the first sequence tag with the same CloneID after ordering the genlight object on based on 
repeatability, avgPIC in that order (method="best") or at random (method="random").

The filter has not been implemented for tag presence/absence data.
}
\examples{
gl.report.secondaries(testset.gl)
result <- gl.filter.secondaries(testset.gl)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
