% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.hwe.r
\name{gl.filter.hwe}
\alias{gl.filter.hwe}
\title{Filters loci that show significant departure from Hardy-Weinberg Equilibrium}
\usage{
gl.filter.hwe(x, alpha = 0.05, basis = "any", bon = TRUE, verbose = NULL)
}
\arguments{
\item{x}{-- a genlight object containing the SNP genotypes [Required]}

\item{alpha}{-- level of significance (per locus) [Default 0.05]}

\item{basis}{-- basis for filtering out loci (any, HWE departure in any one population) [default basis="any"]}

\item{bon}{-- apply bonferroni correction to significance levels for filtering [default TRUE]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2, unless specified using gl.set.verbosity]}
}
\value{
a genlight object with the loci departing significantly from HWE removed
}
\description{
Calculates the probabilities of agreement with H-W equilibrium based on observed
frequencies of reference homozygotes, heterozygotes and alternate homozygotes.
 
Uses the exact calculations contained in function prob.hwe() as developed by
Wigginton, JE, Cutler, DJ, and Abecasis, GR.
}
\details{
Input is a genlight {adegenet} object containing SNP genotypes (0 homozygous for reference SNP, 
1 heterozygous, 2 homozygous for alternate SNP).

Loci are filtered if they show HWE departure in any one population.
Note that power to detect departures from HWE is affected by sample size and that
effective filtering may require substantial sample sizes (n > 20).
}
\examples{
result <- gl.filter.hwe(testset.gl, 0.05, bon=TRUE, verbose=3)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
