% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.genotypes.r
\name{gl.sim.genotypes}
\alias{gl.sim.genotypes}
\title{Generate random genotypes}
\usage{
gl.sim.genotypes(x, n.ind = 200, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{n.ind}{Number of individuals to be simulated (should be less than the number of loci) [default 200]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity]}
}
\value{
Returns a genlight object with the simulated genotypes
}
\description{
Generate random genotypes for a single population drawing upon the allele
frequencies from that population.
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{data manipulation}
