% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.compliance.check.r
\name{gl.compliance.check}
\alias{gl.compliance.check}
\title{Checks a genlight object to see if it complies with dartR
 expectations and amends it to comply if necessary
 @family environment}
\usage{
gl.compliance.check(x, verbose = NULL)
}
\arguments{
\item{x}{Name of the input genlight object [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object that conforms to the expectations of dartR
}
\description{
This function will check to see that the genlight object conforms to
expectation in regard to dartR requirements (see details), and if it does
not, will rectify it.
}
\details{
A genlight object used by dartR has a number of requirements that allow
functions within the package to operate correctly. The genlight object
comprises:
\enumerate{
\item The SNP genotypes or Tag Presence/Absence data (SilicoDArT);
\item An associated dataframe (gl@other$loc.metrics) containing the locus
metrics (e.g. Call Rate, Repeatability, etc);
\item An associated dataframe (gl@other$ind.metrics) containing the
individual/sample metrics (e.g. sex, latitude (=lat), longitude(=lon), etc);
\item A specimen identity field (indNames(gl)) with the unique labels applied
to each individual/sample;
\item A population assignment (popNames) for each individual/specimen;
\item Flags that indicate whether or not calculable locus metrics have been
updated.
}
}
\examples{
x <- gl.compliance.check(testset.gl)
x <- gl.compliance.check(testset.gs)

}
\author{
Custodian: Luis Mijangos -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
