% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDArch.R
\name{runDArchDropout}
\alias{runDArchDropout}
\title{Forward-propagate data through the network with dropout inference}
\usage{
runDArchDropout(darch, data, inputLayer = 1,
  outputLayer = length(darch@layers), matMult = getParameter(".matMult"),
  dropout = getParameter(".darch.dropout"),
  iterations = getParameter(".darch.dropout.momentMatching"))
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{data}{The input data to execute the darch on.}

\item{inputLayer}{Into which layer the given data is to be fed. Absolute
number starting at 1 for the input layer.}

\item{outputLayer}{The output of which layer is to be returned, absolute
number starting a 0 for the input layer (i.e. pre-processed data is
returned).}

\item{matMult}{Function to use for matrix multiplication.}

\item{dropout}{Dropout rates for the layers.}

\item{iterations}{If greater than 0, the numbr of iterations to use for
moment matching dropout inference.}
}
\value{
The network output.
}
\description{
If dropout was disabled, \code{\link{runDArch}} will be called instead.
}
\seealso{
\code{\link{darch}}

Other darch execute functions: \code{\link{runDArch}}
}
\keyword{internal}

