% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_loss.R
\name{plot.exp_loss}
\alias{plot.exp_loss}
\title{Plot of Expected Loss Curves (ELC)}
\usage{
\method{plot}{exp_loss}(
  x,
  log_y = TRUE,
  frontier = TRUE,
  points = TRUE,
  lsize = 1,
  txtsize = 12,
  currency = "$",
  effect_units = "QALY",
  n_y_ticks = 8,
  n_x_ticks = 20,
  xbreaks = NULL,
  ybreaks = NULL,
  xlim = c(0, NA),
  ylim = NULL,
  col = c("full", "bw"),
  ...
)
}
\arguments{
\item{x}{object of class \code{exp_loss}, produced by function
\code{\link{calc_exp_loss}}}

\item{log_y}{take the base 10 log of the y axis}

\item{frontier}{indicate the frontier (also the expected value of perfect information).
To only plot the EVPI see \code{\link{calc_evpi}}.}

\item{points}{whether to plot points on the curve (TRUE) or not (FALSE)}

\item{lsize}{line size. defaults to 1.}

\item{txtsize}{base text size}

\item{currency}{string with currency used in the cost-effectiveness analysis (CEA).
Default: $, but it could be any currency symbol or word (e.g., £, €, peso)}

\item{effect_units}{units of effectiveness. Default: QALY}

\item{n_y_ticks}{number of axis ticks}

\item{n_x_ticks}{number of axis ticks}

\item{xbreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{ybreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{xlim}{vector of axis limits, or NULL, which sets limits automatically}

\item{ylim}{vector of axis limits, or NULL, which sets limits automatically}

\item{col}{either none, full color, or black and white}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} object with the expected loss
}
\description{
Plot of Expected Loss Curves (ELC)
}
