% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample.R
\name{data_sample}
\alias{data_sample}
\title{Data Sample}
\usage{
data_sample()
}
\value{
returns an object of class \code{data_sample}
}
\description{
The data_sample function in R is used to randomly
sample data from a given data frame. It can be used to obtain
a subset of data for further analysis or modeling.

Two basic specializations of data_sample are sample_random and sample_stratified.
They provide random sampling and stratified sampling, respectively.

Data sample provides both training and testing partitioning (train_test) and
k-fold partitioning (k_fold) of data.
}
\examples{
#using random sampling
sample <- sample_random()
tt <- train_test(sample, iris)

# distribution of train
table(tt$train$Species)

# preparing dataset into four folds
folds <- k_fold(sample, iris, 4)

# distribution of folds
tbl <- NULL
for (f in folds) {
 tbl <- rbind(tbl, table(f$Species))
}
head(tbl)
}
