% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_ports_locations.R
\name{join_ports_locations}
\alias{join_ports_locations}
\title{Label points when vessel is at port}
\usage{
join_ports_locations(x, mx_ports = mx_ports, buffer_size = 0.15)
}
\arguments{
\item{x}{a data.frame with latitude and longitude coordinates}

\item{mx_ports}{is a shapefile of point data storing coordinates of ports and marina in Mexico, you can upload this using \code{data("mx_ports")}}

\item{buffer_size}{a number (double) indicating the size of the buffer for the ports to implement}
}
\value{
A data.frame
}
\description{
The function joins ports locations using data from ports buffers. \code{mx_ports} data is used which is
provided by INEGI https://en.www.inegi.org.mx/
}
\details{
The function adds a \code{location} column indicating if the vessel was at port or at sea.
}
\examples{

# With sample data

data("sample_dataset")
data("mx_ports")
vms_cleaned <- vms_clean(sample_dataset)

# It is a good idea to subsample when testing... it takes a while on the full data!

vms_subset <- dplyr::sample_n(vms_cleaned, 1000)
with_ports <- join_ports_locations(vms_subset)
with_ports_sf <- sf::st_as_sf(with_ports, coords = c("longitude", "latitude"), crs = 4326)

data("mx_shape")
library(ggplot2)
ggplot(mx_shape) +
  geom_sf(col = "gray90") +
  geom_sf(data = with_ports_sf, aes(col = location)) +
  facet_wrap(~location) +
  theme_bw()
}
