% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-diff.R
\name{render_diff}
\alias{render_diff}
\title{Render a data_diff to html}
\usage{
render_diff(diff, file = tempfile(fileext = ".html"),
  view = interactive(), fragment = FALSE, pretty = TRUE, title,
  summary = !fragment, use.DataTables = !fragment)
}
\arguments{
\item{diff}{\code{diff_data object} generated with \code{\link{diff_data}}}

\item{file}{\code{character}        target file (optional)}

\item{view}{\code{logical}          Open the generated HTML in a browser
if R is being used interactively}

\item{fragment}{\code{logical}          If \code{TRUE} generate (just) an
HTML table, otherwise
generate a valid HTML document.}

\item{pretty}{\code{logical}          Use HTML arrow characters instead of '-->'.}

\item{title}{\code{character}        title text. Defaults to the quoted
names of the data objects compared,
separated by 'vs.'}

\item{summary}{\code{logical}          Should a summary of changes be shown above
the HTML table?}

\item{use.DataTables}{\code{logical}    Include jQuery DataTables plugin and enable:
- pagination (10,25,50,100,All)
- searching
- filtering
- column visibility (individually enable/disable)
- copy/csv/excel/pdf export buttons
- column reorder (drag and drop)
- row reorder (drag and drop)
- row/multirow select}
}
\value{
generated html
}
\description{
Converts a diff_data object to HTML code, and opens the resulting HTML code
in a browser window if \code{view==TRUE} and R is running interactively.
}
\examples{
y <- iris[1:3,]
x <- y

x <- head(x,2) # remove a row
x[1,1] <- 10 # change a value
x$hello <- "world"  # add a column
x$Species <- NULL # remove a column

patch <- diff_data(y, x)
render_diff(patch, title="compare x and y", pretty = TRUE)

#apply patch
y_patched <- patch_data(y, patch)
}
\seealso{
data_diff
}
