% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_drift_dm.R
\name{summary.drift_dm}
\alias{summary.drift_dm}
\alias{print.summary.drift_dm}
\title{Summary for \code{drift_dm} Objects}
\usage{
\method{summary}{drift_dm}(object, ...)

\method{print}{summary.drift_dm}(x, ..., round_digits = drift_dm_default_rounding())
}
\arguments{
\item{object}{An object of class \code{drift_dm}}

\item{...}{additional arguments passed forward to the respective method}

\item{x}{an object of type \code{summary.drift_dm}}

\item{round_digits}{Integer specifying the number of decimal places for
rounding in the printed summary. Default is 3.}
}
\value{
\code{summary.drift_dm()} returns a list of class \code{summary.drift_dm} (see the
Details section summarizing each entry of this list).

\code{print.summary.drift_dm()} returns invisibly the \code{summary.drift_dm} object.
}
\description{
Summary and printing methods for objects of the class \code{drift_dm}, resulting
from a call to \link{drift_dm}.
}
\details{
The \code{summary.drift_dm()} function constructs a summary list with detailed
information about the \code{drift_dm} object, including:
\itemize{
\item \strong{class}: The class type of the \code{drift_dm} object.
\item \strong{summary_flex_prms}: A summary of the \link{flex_prms} object in the
model (see \link{summary.flex_prms}).
\item \strong{prms_solve}: Parameters used for solving the model (see
\link{prms_solve}).
\item \strong{solver}: The solver used for model fitting.
\item \strong{obs_data}: A summary table of observed response time data, if available,
by response type (upper/lower boundary responses). Includes sample size,
mean, and quantiles.
\item \strong{fit_stats}: Fit statistics, if available, including log-likelihood,
AIC, and BIC values.
}

The \code{print.summary.drift_dm()} function displays this summary in a formatted
way.
}
\examples{
# get a pre-built model for demonstration purpose
a_model <- dmc_dm(t_max = 1.5, dx = .0025, dt = .0025)
sum_obj <- summary(a_model)
print(sum_obj, round_digits = 2)

# more information is provided when we add data to the model
obs_data(a_model) <- dmc_synth_data # (data set comes with dRiftDM)
summary(a_model)

# finally: fit indices are provided once we evaluate the model
a_model <- re_evaluate_model(a_model)
summary(a_model)

}
