% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.list_stats_dm}
\alias{plot.list_stats_dm}
\title{Plot Multiple Statistics}
\usage{
\method{plot}{list_stats_dm}(x, ..., mfrow = NULL)
}
\arguments{
\item{x}{an object of type \code{list_stats_dm}, which is essentially a list
multiple statistics, resulting from a call to \code{\link[=calc_stats]{calc_stats()}}.}

\item{...}{additional arguments passed to the \link{plot} function for each
individual \code{stats_dm} object in \code{x}.}

\item{mfrow}{an optional numeric vector of length 2, specifying the number of
rows and columns for arranging multiple panels in a single plot
(e.g., \code{c(1, 3)}). Plots are provided sequentially if \code{NULL} (default),
using the current graphics layout of a user.}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function iterates over a list of statistics data, resulting from a call
to \code{\link[=calc_stats]{calc_stats()}}, and subsequently plots each statistic. It allows
for flexible arrangement of multiple plots on a single graphics device.
}
\details{
The \code{plot.list_stats_dm()} function is "merely" a wrapper. All plotting
is done by the respective \code{plot()} methods. When users want more control
over each plot, it is best to call the \code{plot()} function separately for
each statistic in the list (e.g., \code{plot(x$cafs)}; \code{plot(x$quantiles)})
}
\examples{
# get a list of statistics for demonstration purpose
all_fits <- get_example_fits_ids()
stats <- calc_stats(all_fits, type = c("cafs", "quantiles"))

# then call the plot function.
plot(stats, mfrow = c(1, 2))

}
\seealso{
\code{\link[=plot.cafs]{plot.cafs()}}, \code{\link[=plot.quantiles]{plot.quantiles()}},
\code{\link[=plot.delta_funs]{plot.delta_funs()}}, \code{\link[=calc_stats]{calc_stats()}}
}
