% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{Xs}
\alias{Xs}
\title{Model prediction function for ODE models.}
\usage{
Xs(odemodel, forcings = NULL, events = NULL, names = NULL,
  condition = NULL, optionsOde = list(method = "lsoda"),
  optionsSens = list(method = "lsodes"))
}
\arguments{
\item{odemodel}{object of class \link{odemodel}}

\item{forcings}{data.frame with columns name (factor), time (numeric) and value (numeric).
The ODE forcings.}

\item{events}{data.frame of events with columns "var" (character, the name of the state to be
affected), "time" (numeric, time point), "value" (numeric, value), "method" (character, either
"replace", "add" or "multiply"). See \link[deSolve]{events}.
ATTENTION: Sensitivities for event states will only be correctly computed if defined within
\code{\link{odemodel}()}. Specify events within \code{Xs()} only for forward simulation.}

\item{names}{character vector with the states to be returned. If NULL, all states are returned.}

\item{condition}{either NULL (generic prediction for any condition) or a character, denoting
the condition for which the function makes a prediction.}

\item{optionsOde}{list with arguments to be passed to odeC() for the ODE integration.}

\item{optionsSens}{list with arguments to be passed to odeC() for integration of the extended system}
}
\value{
Object of class \link{prdfn}. If the function is called with parameters that
result from a parameter transformation (see \link{P}), the Jacobian of the parameter transformation
and the sensitivities of the ODE are multiplied according to the chain rule for
differentiation. The result is saved in the attributed "deriv", 
i.e. in this case the attibutes "deriv" and "sensitivities" do not coincide.
}
\description{
Interface to combine an ODE and its sensitivity equations
into one model function \code{x(times, pars, deriv = TRUE)} returning ODE output and sensitivities.
}
