% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3po-api.R
\name{po_pie}
\alias{po_pie}
\title{Pie}
\usage{
po_pie(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot a pie
}
\examples{
library(dplyr)

pokemon_count <- pokemon \%>\% 
 group_by(type_1, color_1) \%>\% 
 count()
 
d3po(pokemon_count) \%>\%
 po_pie(
  daes(size = n, group = type_1, color = color_1)
 ) \%>\%
 po_title("Share of Pokemon by Type 1")

}
