% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3po-api.R
\name{po_line}
\alias{po_line}
\title{Line}
\usage{
po_line(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot an line chart.
}
\examples{
library(dplyr)

pokemon_decile <- pokemon \%>\% 
 filter(type_1 \%in\% c("grass", "fire", "water")) \%>\% 
 group_by(type_1 ,color_1) \%>\% 
 summarise(
  decile = 0:10,
  weight = quantile(weight, probs = seq(0, 1, by = .1))
 )
 
d3po(pokemon_decile) \%>\%
 po_line(
  daes(x = decile, y = weight, group = type_1, color = color_1)
 ) \%>\%
 po_title("Decile of Pokemon Weight by Type 1")

}
