% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytometree-package.R
\docType{package}
\name{cytometree-package}
\alias{cytometree-package}
\alias{cytometree}
\title{Binary tree algorithm for cytometry data analysis.}
\description{
The algorithm is based on the construction of a binary tree, 
the nodes of which are subpopulations of cells. At each node, 
observed cells and markers are modeled by both a family of normal
distributions and a family of bimodal normal mixture distributions. 
Splitting is done according to a normalized difference of AIC between 
the two families.
Given the unsupervised nature of the binary tree, some of the available
markers may not be used to find the different cell populations present in 
a given sample. To recover a complete annotation, we defined, as a post 
processing procedure, an annotation method which allows the user to 
distinguish two or three expression levels per marker.
}
\details{
\tabular{ll}{
Package: \tab cytometree\cr
Type: \tab Package\cr
Version: \tab 1.1.1\cr
Date: \tab 2017-10-18\cr
License:\tab \href{http://www.gnu.org/licenses/lgpl.txt}{LGPL-3}\cr
}
The main function in this package is \code{\link{CytomeTree}}.
}
\references{
D. Commenges, C. Alkhassim, B.P. Hejblum, R. Thi\'ebaut. 
cytometree: a Binary tree algorithm for automatic gating in cytometry analysis. 
Submitted, 2017.
}
\author{
Chariff Alkhassim, Boris Hejblum
--- Maintainer: Chariff Alkhassim
}
