% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxr_generate_test_data.R
\name{cxr_generate_test_data}
\alias{cxr_generate_test_data}
\title{Generate simulated interaction data}
\usage{
cxr_generate_test_data(
  focal_sp = 1,
  neigh_sp = 1,
  covariates = 0,
  observations = 10,
  alpha_form = c("pairwise", "none", "global"),
  lambda_cov_form = c("none", "global"),
  alpha_cov_form = c("none", "global", "pairwise"),
  focal_lambda = NULL,
  min_lambda = 0,
  max_lambda = 10,
  alpha = NULL,
  min_alpha = 0,
  max_alpha = 1,
  alpha_cov = NULL,
  min_alpha_cov = -1,
  max_alpha_cov = 1,
  lambda_cov = NULL,
  min_lambda_cov = -1,
  max_lambda_cov = 1,
  min_cov = 0,
  max_cov = 1
)
}
\arguments{
\item{focal_sp}{number of focal species, defaults to 1.}

\item{neigh_sp}{number of neighbour species, defaults to 1.}

\item{covariates}{number of covariates, defaults to 0.}

\item{observations}{number of observations, defaults to 10.}

\item{alpha_form}{what form does the alpha parameter take? one of "none" (no alpha in the model), 
"global" (a single alpha for all pairwise interactions), or "pairwise" (one alpha value for every interaction).}

\item{lambda_cov_form}{form of the covariate effects on lambda. Either "none" (no covariate effects) or "global" (one estimate per covariate).}

\item{alpha_cov_form}{form of the covariate effects on alpha. One of "none" (no covariate effects), "global" (one estimate per covariate on every alpha),
or "pairwise" (one estimate per covariate and pairwise alpha).}

\item{focal_lambda}{optional 1d vector with lambdas of the focal sp.}

\item{min_lambda}{if no focal_lambda is provided, lambdas are taken from a uniform distribution
with min_lambda and max_lambda as minimum and maximum values.}

\item{max_lambda}{if no focal_lambda is provided, lambdas are taken from a uniform distribution
with min_lambda and max_lambda as minimum and maximum values.}

\item{alpha}{optional interaction matrix, neigh_sp x neigh_sp}

\item{min_alpha}{if no focal_alpha is provided, alphas are taken from a uniform distribution
with min_alpha and max_alpha as minimum and maximum values.}

\item{max_alpha}{if no focal_alpha is provided, alphas are taken from a uniform distribution
with min_alpha and max_alpha as minimum and maximum values.}

\item{alpha_cov}{----------Under development-------------}

\item{min_alpha_cov}{if no focal_alpha_cov is provided, alpha_covs are taken from a uniform distribution
with min_alpha_cov and max_alpha_cov as minimum and maximum values.}

\item{max_alpha_cov}{if no focal_alpha_cov is provided, alpha_covs are taken from a uniform distribution
with min_alpha and max_alpha as minimum and maximum values.}

\item{lambda_cov}{optional matrix of neigh_sp x covariates
giving the effect of each covariate over the fecundity (lambda) of each species.}

\item{min_lambda_cov}{if no focal_lambda_cov is provided, lambda_covs are taken from a uniform distribution
with min_lambda_cov and max_lambda_cov as minimum and maximum values.}

\item{max_lambda_cov}{if no focal_lambda_cov is provided, lambda_covs are taken from a uniform distribution
with min_lambda and max_lambda as minimum and maximum values.}

\item{min_cov}{minimum value for covariates}

\item{max_cov}{maximum value for covariates}
}
\value{
list with two components: 'observations' is a list with as many components as focal species. 
Each component of 'observations' is a dataframe with stochastic number of neighbours and associated fitness.
The second component, 'covariates', is again a list with one component per focal species. 
Each component of 'covariates' is a dataframe with the values of each covariate for each associated observation.
}
\description{
Model fitness responses to neighbours and covariates
using a Beverton-Holt functional form. This function
is fairly restricted and under development, but can be used
to generate simple test data to run the main functions of \code{cxr}.
}
\examples{
example_obs <- cxr_generate_test_data(focal_sp = 2,
                                      neigh_sp = 2,
                                      alpha_form = "pairwise",
                                      lambda_cov_form = "global",
                                      alpha_cov_form = "global",
                                      covariates = 1)

}
