% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_flat_subsystems}
\alias{cvd_area_flat_subsystems}
\title{Area flat subsystems}
\usage{
cvd_area_flat_subsystems(area_id = 5)
}
\arguments{
\item{area_id}{integer - the area to return data for (compulsory)}
}
\value{
Tibble of details for the area and its child areas (where applicable)
}
\description{
Similar to \code{cvd_area_nested_subsystems()} but the sub-areas are grouped
based on their system level.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2F\%3Carea_id\%3E\%2FflatSubSystems}{Area flat subsystems}
}
\examples{
# View details for for Somerset STP
cvd_area_flat_subsystems(area_id = 5) |>
  dplyr::glimpse()

# View details for Leicester Central PCN
cvd_area_flat_subsystems(area_id = 701) |>
  dplyr::glimpse()
}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}
}
