% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mcc.R
\encoding{UTF-8}
\name{plot_mcc}
\alias{plot_mcc}
\title{Constructs a control chart for the marginal distribution of a categorical
series}
\usage{
plot_mcc(
  series,
  c,
  sigma,
  lambda = 0.99,
  k = 3.3,
  min_max = FALSE,
  plot = TRUE,
  title = "Control chart (marginal)",
  ...
)
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Values
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{c}{The hypothetical marginal distribution.}

\item{sigma}{A matrix containing the variances for each category (columns)
and each time t (rows).}

\item{lambda}{The constant lambda to construct the EWMA estimator.}

\item{k}{The constant k to construct the k sigma limits.}

\item{min_max}{Logical. If \code{min_max = FALSE} (default), the standard
control chart for the marginal distribution is plotted. Otherwise, the
reduced control chart is plotted, i.e., only the minimum and maximum values
of the standardized statistics (with respect to the set of categories) are considered.}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the control
chart. Otherwise, returns the standardized statistics or their maximum and
minimum value for each time t.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), represents the control chart for the marginal distribution. Otherwise, the function
returns a matrix with the values of the standardized statistics for each time t
}
\description{
\code{plot_mcc} constructs a control chart for the marginal distribution
of a categorical series
}
\details{
Constructs a control chart of a CTS with range \eqn{\mathcal{V}=\{1, \ldots, r\}} based on the marginal distribution. The chart relies on the
standardized statistic \eqn{T_{t, i}=\frac{\hat{\pi}_{t, i}^{(\lambda)}-p_i}{k \cdot \sigma_{t, i}}}, where the \eqn{\hat{\pi}_{t, i}^{(\lambda)}},
\eqn{i=1,\ldots,r}, are the components of the EWMA estimator of the marginal
distribution, \eqn{p_i} is the marginal probability of category \eqn{i},
\eqn{\sigma_{t,i}} is the variance of \eqn{\hat{\pi}_{t, i}^{(\lambda)}} and \eqn{k}
is a constant set by the user. If \code{min_max = FALSE}, then only the
statistics \eqn{T_t^{\min }=\min_{i \in \mathcal{V}} T_{t, i}} and
\eqn{T_t^{\max }=\max_{i \in \mathcal{V}} T_{t, i}} are plotted.
An out-of-control alarm is signalled if the statistics are below -1 or
above 1.
}
\examples{
sequence_1 <- SyntheticData1[which(SyntheticData1$Series==1),]
cycle_cc <- plot_ccc(series = sequence_1, mu_t = c(1, 1.5, 1),
lcl_t = rep(10, 600), ucl_t = rep(10, 600))
cycle_md <- plot_mcc(series = sequence_1, c = c(0.3, 0.3, 0.4),
sigma = matrix(rep(c(1, 1, 1), 600), nrow = 600)) # Representing
# a control chart for the marginal distribution
cycle_md <- plot_mcc(series = sequence_1, c = c(0.3, 0.3, 0.4),
sigma = matrix(rep(c(1, 1, 1), 600), nrow = 600), plot = FALSE) # Computing the
# corresponding standardized statistic
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
