% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfMergeVariablesRelevel}
\alias{dfMergeVariablesRelevel}
\title{Merge variables, keeping type, and optionally relevel factors}
\usage{
dfMergeVariablesRelevel(df = NULL, colnames = "", levelslist = NULL)
}
\arguments{
\item{df}{A \link{data.frame} with the variables (columns) to be merged into
one vector.}

\item{colnames}{A vector of names of columns in `df` that hold the variables
to be merged, or a selection of columns as per \code{\link[dplyr]{select}}.}

\item{levelslist}{A names list with one slice each for a new value to be
used for a vector of old values (optional).}
}
\value{
A vector, with the type of the columns to be merged
}
\description{
Merge variables in a data frame such as returned by \link{dbGetFieldsIntoDf}
into a new variable, and optionally also map its values to new levels.
}
\examples{

dbc <- nodbi::src_sqlite(
   dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
   collection = "my_trials")

df <- dbGetFieldsIntoDf(
  fields = c("overall_status", "x5_trial_status"),
  con = dbc)

statusvalues <- list(
  "ongoing" = c("Recruiting", "Active", "Ongoing"),
  "completed" = c("Completed", "Prematurely Ended", "Terminated"),
  "other" = c("Withdrawn", "Suspended", "No longer available"))

dfMergeVariablesRelevel(
  df = df,
  colnames = 'contains("status")',
  levelslist = statusvalues)

}
