% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inprod.cent.R
\name{inprod.cent}
\alias{inprod.cent}
\title{Centered inner product matrix for a basis or pair of bases}
\usage{
inprod.cent(basis1, basis2 = basis1, rng = NULL)
}
\arguments{
\item{basis1}{basis object from the \code{\link[fda]{fda}} package.}

\item{basis2}{an optional second basis}

\item{rng}{time range. By default, the entire range spanned by the basis, or the intersection of the ranges of the two bases.}
}
\value{
Matrix of inner products of each pair of centered basis functions.
}
\description{
Several methods of continous-time multivariate analysis require a matrix of
inner products of pairs of centered functions from a basis, such as a B-spline basis,
or pairs consisting of one function from each of two bases. This function computes
such matrices via 7-point Newton-Cotes integration, which is exact for cubic
B-splines. For a Fourier basis with the inner product taken over the entire range,
a simple closed form is used instead of integration.
}
\examples{


require(fda)
bbasis6 <- create.bspline.basis(nbasis=6)
inprod.cent(bbasis6)
fbasis7 <- create.fourier.basis(nbasis=7)
inprod.cent(fbasis7)

}
\seealso{
\code{\link[fda]{create.bspline.basis}} from package \code{\link[fda]{fda}}, for the most commonly used basis object type.
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
