#' @details This package provides 3 functions for mass-downloading
#'     historical clinical trial registry entry data from
#'     ClinicalTrials.gov
#'
#' @details clinicaltrials_gov_dates() downloads the dates on which
#'     clinical trial registry entries were updated from
#'     ClinicalTrials.gov
#'
#' @details clinicaltrials_gov_version() downloads a specified
#'     historical version of a clinical trial registry entry from
#'     ClinicalTrials.gov
#'
#' @details clinicaltrials_gov_download() mass-downloads clinical
#'     trial registry entry versions for one or many trials on
#'     ClinicalTrials.gov
#'
#' @references Carlisle, BG. Analysis of clinical trial registry entry
#'     histories using the novel R package cthist. medRxiv, 2022. doi:
#'     10.1101/2022.01.20.22269538
#' 
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
