/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.PointInRing;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.strtree.SIRtree;
import java.util.Iterator;
import java.util.List;

public class SIRtreePointInRing
implements PointInRing {
    private LinearRing ring;
    private SIRtree sirTree;
    private int crossings = 0;

    public SIRtreePointInRing(LinearRing ring) {
        this.ring = ring;
        this.buildIndex();
    }

    private void buildIndex() {
        Envelope env = this.ring.getEnvelopeInternal();
        this.sirTree = new SIRtree();
        Coordinate[] pts = this.ring.getCoordinates();
        for (int i = 1; i < pts.length; ++i) {
            if (pts[i - 1].equals(pts[i])) continue;
            LineSegment seg = new LineSegment(pts[i - 1], pts[i]);
            this.sirTree.insert(seg.p0.y, seg.p1.y, seg);
        }
    }

    public boolean isInside(Coordinate pt) {
        this.crossings = 0;
        List segs = this.sirTree.query(pt.y);
        Iterator i = segs.iterator();
        while (i.hasNext()) {
            LineSegment seg = (LineSegment)i.next();
            this.testLineSegment(pt, seg);
        }
        return this.crossings % 2 == 1;
    }

    private void testLineSegment(Coordinate p, LineSegment seg) {
        double xInt;
        Coordinate p1 = seg.p0;
        Coordinate p2 = seg.p1;
        double x1 = p1.x - p.x;
        double y1 = p1.y - p.y;
        double x2 = p2.x - p.x;
        double y2 = p2.y - p.y;
        if ((y1 > 0.0 && y2 <= 0.0 || y2 > 0.0 && y1 <= 0.0) && 0.0 < (xInt = (double)RobustDeterminant.signOfDet2x2(x1, y1, x2, y2) / (y2 - y1))) {
            ++this.crossings;
        }
    }
}

