% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-variable.R
\name{fillExpr}
\alias{fillExpr}
\title{Expression to fill a variable from another}
\usage{
fillExpr(x, fills, ..., data = NULL, type = NULL)
}
\arguments{
\item{x}{a Categorical (Array) variable}

\item{fills}{a list of lists that each have a "fill" item that is a variable or expression
as well as one of an "id", "name", or "value" that will be matched to the categories of x
If x is an expression, the fills must be an id}

\item{...}{A sequence of named expressions or variables to use as fills, where the name will be
matched to the existing categories}

\item{data}{(optional) a crunch dataset to use. Specifying this means you don't have to put
\verb{dataset$} in front of each variable name}

\item{type}{The type of the variable to output (either "categorical" or "numeric"), only
required if all fills are expressions and so their type cannot be guessed automatically.}
}
\value{
A \code{CrunchExpression} that assigns categories to filling variables
}
\description{
Given a categorical variable, assign one or more categories to be filled in by
another existing variable or crunch expression. (Categories not filled in will
remain unchanged ).
}
\examples{
\dontrun{
fillExpr(
    ds$v1,
    fills = list(
        list(fill = ds$v2, name = "dog")
    )
)
fillExpr(v1, "dog" = ds$v2)

# the dataset can be specified with data=
fillExpr(v1, "dog" = v2, data = ds)
}
}
\keyword{internal}
