% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_crs.R
\name{crs_wkt2}
\alias{crs_wkt2}
\title{Extract 'WKT2' string}
\usage{
crs_wkt2(x, ...)
}
\arguments{
\item{x}{object with 'WKT2' string}

\item{...}{ignored}
}
\value{
character string (or \code{NA})
}
\description{
Obtain the 'WKT2' string from an object, if it has one. Supported inputs
include sp and sf.
}
\section{Warning}{
 For WKT2 only, PROJ6 and beyond
}

\examples{
crs_wkt2(sfx)

crs_wkt2(sfx$geom)
}
\references{
\href{http://docs.opengeospatial.org/is/12-063r5/12-063r5.html}{WKT2 specification}
}
\seealso{
\code{\link[=crs_epsg]{crs_epsg()}} \code{\link[=crs_proj]{crs_proj()}}
}
