% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.crossnma.R
\name{print.crossnma}
\alias{print.crossnma}
\title{Print call used to create JAGS model for cross-design & -format
network meta-analysis or regression}
\usage{
\method{print}{crossnma}(x, ...)
}
\arguments{
\item{x}{An object of class \code{crossnma}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
No return value (print function).
}
\description{
Print call used to create JAGS model for cross-design & -format
network meta-analysis or regression
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))
fit

}
\seealso{
\code{\link{crossnma}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
