% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossnma.R
\name{crossnma}
\alias{crossnma}
\title{Run JAGS to fit cross NMA and NMR}
\usage{
crossnma(
  x,
  n.adapt = 1000,
  n.burnin = floor(n.iter/2),
  n.iter = 10000,
  thin = 1,
  n.chains = 2,
  quiet = TRUE,
  monitor = NULL
)
}
\arguments{
\item{x}{An object produced by \code{\link{crossnma.model}}.}

\item{n.adapt}{Number of adaptations for the MCMC chains. Default
is 1000.}

\item{n.burnin}{Number of burnin iterations for the MCMC chains.}

\item{n.iter}{Number of iterations for the MCMC chains.}

\item{thin}{Number of thinning for the MCMC chains. Default is 1.}

\item{n.chains}{Number of MCMC chains. Default is 2.}

\item{quiet}{A logical passed on to
\code{\link[rjags]{jags.model}}.}

\item{monitor}{A vector of additional parameters to
monitor. Default is NULL.}
}
\value{
An object of class \code{crossnma} which is a list containing the
following components:
\item{samples}{The MCMC samples produced by running the JAGS
  model.}
\item{model}{The \code{crossnma.model} object obtained from
  \code{\link{crossnma.model}} which was used to run JAGS.}
\item{trt.key}{A table of treatment names and their correspondence
  to integers used in the JAGS model.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{crossnma} used to create
  object.}
}
\description{
This function takes the JAGS model from an object produced by
\code{\link{crossnma.model}} and runs it using \code{jags.model} in
rjags package.
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Display the output
summary(fit)
plot(fit)

}
\seealso{
\code{\link{crossnma.model}},
  \code{\link[rjags]{jags.model}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
