% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_xmap_mat.R
\name{future_xmap_mat}
\alias{future_xmap_mat}
\alias{future_xmap_arr}
\title{Parallelized cross map returning a matrix or array}
\usage{
future_xmap_mat(
  .l,
  .f,
  ...,
  .names = TRUE,
  .progress = FALSE,
  .options = furrr::furrr_options()
)

future_xmap_arr(
  .l,
  .f,
  ...,
  .names = TRUE,
  .progress = FALSE,
  .options = furrr::furrr_options()
)
}
\arguments{
\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.names}{A logical indicating whether to give names to the dimensions of
the matrix or array.
If inputs are named, the names are used.
If inputs are unnamed, the elements of the input are used as names.
Defaults to \code{TRUE}.}

\item{.progress}{A single logical. Should a progress bar be displayed?
Only works with multisession, multicore, and multiprocess futures. Note
that if a multicore/multisession future falls back to sequential, then
a progress bar will not be displayed.

\strong{Warning:} The \code{.progress} argument will be deprecated and removed
in a future version of furrr in favor of using the more robust
\href{https://CRAN.R-project.org/package=progressr}{progressr}
package.}

\item{.options}{The \code{future} specific options to use with the workers. This
must be the result from a call to \code{\link[furrr:furrr_options]{furrr_options()}}.}
}
\value{
A matrix (for \code{future_xmap_mat()}) or array (for \code{future_xmap_arr()})
with dimensions matching the lengths of each input in \code{.l}.
}
\description{
Parallelized cross map returning a matrix or array
}
\examples{
future_xmap_mat(list(1:3, 1:3),  ~ ..1 * ..2)

fruits <- c(a = "apple", b = "banana", c = "cantaloupe")
future_xmap_mat(list(1:3, fruits), paste)
future_xmap_mat(list(1:3, fruits), paste, .names = FALSE)

future_xmap_arr(list(1:3, 1:3, 1:3),  ~ ..1 * ..2 * ..3)
}
\seealso{
Unparallelized versions: \code{\link[=xmap_mat]{xmap_mat()}} and \code{\link[=xmap_arr]{xmap_arr()}}

\code{\link[=future_xmap_vec]{future_xmap_vec()}} to return a vector.

\code{\link[=future_xmap]{future_xmap()}} for the underlying functions.
}
